<?php
session_start();
include('koneksi.php');

// Inisialisasi bobot
$W1 = 0; // Harga
$W2 = 0; // Processor
$W3 = 0; // RAM
$W4 = 0; // VGA
$W5 = 0; // Memori
$W6 = 0; // LCD

// Tentukan bobot berdasarkan preset atau input manual
if (isset($_POST['action'])) { // Jika form preset yang disubmit
    $preset = $_POST['preset'];

    switch ($preset) {
        case 'gaming':
            $W1 = 1;  // Harga (Gaming mungkin kurang prioritas)
            $W2 = 4; // Processor (Sangat Sangat Penting)
            $W3 = 5;  // RAM (Sangat Penting)
            $W4 = 5;  // VGA (Sangat Penting)
            $W5 = 4;  // Memori (Penting)
            $W6 = 2;  // LCD (Penting)
            break;
        case 'kantor':
            $W1 = 3;  // Harga (Cukup Penting)
            $W2 = 3;  // Processor (Standar)
            $W3 = 2;  // RAM (Cukup)
            $W4 = 3;  // VGA (Kurang)
            $W5 = 3;  // Memori (Cukup)
            $W6 = 2;  // LCD (Cukup)
            break;
        case 'desain':
            $W1 = 2;  // Harga (Tidak terlalu prioritas)
            $W2 = 4;  // Processor (Sangat Penting)
            $W3 = 4;  // RAM (Sangat Penting)
            $W4 = 5; // VGA (Sangat Sangat Penting)
            $W5 = 4; // Memori (Sangat Penting)
            $W6 = 5;  // LCD (Sangat Penting)
            break;
        case 'pelajar':
            $W1 = 5; // Harga (Sangat Penting)
            $W2 = 3;  // Processor (Standar)
            $W3 = 3;  // RAM (Cukup)
            $W4 = 2;  // VGA (Kurang Penting)
            $W5 = 2;  // Memori (Penting)
            $W6 = 3;  // LCD (Lumayan)
            break;
        case 'umum':
        default: // Default atau pilihan umum
            $W1 = 3; // Harga
            $W2 = 3; // Processor
            $W3 = 3; // RAM
            $W4 = 3; // VGA
            $W5 = 3; // Memori
            $W6 = 3; // LCD
            break;
    }
} elseif (isset($_POST['action_manual'])) { // Jika form manual yang disubmit
    $W1 = $_POST['harga_manual'];
    $W2 = $_POST['processor_manual'];
    $W3 = $_POST['ram_manual'];
    $W4 = $_POST['vga_manual'];
    $W5 = $_POST['memori_manual'];
    $W6 = $_POST['lcd_manual'];
} else {
    // Jika tidak ada input, bisa diarahkan kembali atau set bobot default
    header('Location: rekomendasi.php');
    exit;
}

// Normalisasi bobot yang sudah didapatkan dari preset/manual
$total_bobot = $W1 + $W2 + $W3 + $W4 + $W5 + $W6;
// Hindari pembagian dengan nol jika total_bobot adalah 0
if ($total_bobot == 0) {
    echo "Total bobot tidak boleh nol. Kembali ke halaman rekomendasi.";
    echo "<a href='rekomendasi.php'>Kembali</a>";
    exit;
}

$W1_norm = $W1 / $total_bobot;
$W2_norm = $W2 / $total_bobot;
$W3_norm = $W3 / $total_bobot;
$W4_norm = $W4 / $total_bobot;
$W5_norm = $W5 / $total_bobot;
$W6_norm = $W6 / $total_bobot;

?>
<?php
include ('header.php');
?>

<body>
    <div class="navbar-fixed">
        <nav>
            <div class="container">
                <div class="nav-wrapper">
                    <ul class="left" style="margin-left: -52px;">
                        <li><a href="index.php">HOME</a></li>
                        <li><a href="daftar_laptop.php">DAFTAR LAPTOP</a></li>
                        <li><a href="login.php">LOGIN</a></li>
                    </ul>
                </div>
            </div>
        </nav>
    </div>
    <div style="background-color: #efefef">
        <div class="container">
            <div class="section-card" style="padding: 20px 0px">
                <center>
                    <h4 class="header" style="margin-left: 24px; margin-bottom: 0px; margin-top: 24px; color: #635c73;">
                        HASIL REKOMENDASI LAPTOP <?php echo strtoupper($preset) ?></h4>
                </center>
                <ul>
                    <li>
                        <div class="row">
                            <div class="card">
                                <div class="card-content">
                                    <h5 style="margin-bottom: 16px; margin-top: -6px;">Matrik Laptop</h5>
                                    <table class="responsive-table">

                                        <thead style="border-top: 1px solid #d0d0d0;">
                                            <tr>
                                                <th>
                                                    <center>Alternatif</center>
                                                </th>
                                                <th>
                                                    <center>C1 (Harga - Cost)</center>
                                                </th>
                                                <th>
                                                    <center>C2 (Processor - Benefit)</center>
                                                </th>
                                                <th>
                                                    <center>C3 (RAM - Benefit)</center>
                                                </th>
                                                <th>
                                                    <center>C4 (VGA - Benefit)</center>
                                                </th>
                                                <th>
                                                    <center>C5 (Memory - Benefit)</center>
                                                </th>
                                                <th>
                                                    <center>C6 (LCD - Benefit)</center>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
											// Mengambil data dari database
											$query=mysqli_query($selectdb,"SELECT * FROM data_laptop");
											$no=1;
											$Matrik = array(); // Inisialisasi Matrik untuk WP
											while ($data_laptop=mysqli_fetch_array($query)) {
												// Simpan data mentah ke dalam Matrik
												$Matrik[$no-1]=array(
                                                    $data_laptop['harga_angka'],
                                                    $data_laptop['processor_angka'],
                                                    $data_laptop['ram_angka'],
                                                    $data_laptop['vga_angka'], // Added VGA
                                                    $data_laptop['memori_angka'],
                                                    $data_laptop['lcd_angka'] // Added LCD
                                                );
												?>
                                            <tr>
                                                <td>
                                                    <center><?php echo "A",$no ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['harga_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['processor_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['ram_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['vga_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['memori_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['lcd_angka'] ?></center>
                                                </td>
                                            </tr>
                                            <?php
												$no++;
											}
											?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>

                <center>
                    <h4 class="header" style="margin-left: 24px; margin-bottom: 0px; margin-top: 24px; color: #635c73;">
                        Matriks Keputusan (Raw):</h4>
                </center>
                <ul>
                    <li>
                        <div class="row">
                            <div class="card">
                                <div class="card-content">
                                    <h5 style="margin-bottom: 16px; margin-top: -6px;">Matriks Keputusan (Raw)</h5>
                                    <table class="responsive-table">

                                        <thead style="border-top: 1px solid #d0d0d0;">
                                            <tr>
                                                <th>
                                                    <center>Alternatif</center>
                                                </th>
                                                <th>
                                                    <center>C1 (Harga)</center>
                                                </th>
                                                <th>
                                                    <center>C2 (Processor)</center>
                                                </th>
                                                <th>
                                                    <center>C3 (RAM)</center>
                                                </th>
                                                <th>
                                                    <center>C4 (VGA)</center>
                                                </th>
                                                <th>
                                                    <center>C5 (Memori)</center>
                                                </th>
                                                <th>
                                                    <center>C6 (LCD)</center>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
											$query=mysqli_query($selectdb,"SELECT * FROM data_laptop");
											$no=1;
											while ($data_laptop=mysqli_fetch_array($query)) { ?>
                                            <tr>
                                                <td>
                                                    <center><?php echo "A",$no ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['harga_angka']?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['processor_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['ram_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['vga_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['memori_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop['lcd_angka'] ?></center>
                                                </td>
                                            </tr>
                                            <?php
													$no++;
												}
												?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>


                <center>
                    <h4 class="header" style="margin-left: 24px; margin-bottom: 0px; margin-top: 24px; color: #635c73;">
                        BOBOT TERNORMALISASI (W)</h4>
                </center>
                <ul>
                    <li>
                        <div class="row">
                            <div class="card">
                                <div class="card-content">
                                    <h5 style="margin-bottom: 16px; margin-top: -6px;">BOBOT TERNORMALISASI (W)</h5>
                                    <table class="responsive-table">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <center>W1 (Harga)</center>
                                                </th>
                                                <th>
                                                    <center>W2 (Processor)</center>
                                                </th>
                                                <th>
                                                    <center>W3 (RAM)</center>
                                                </th>
                                                <th>
                                                    <center>W4 (VGA)</center>
                                                </th>
                                                <th>
                                                    <center>W5 (Memori)</center>
                                                </th>
                                                <th>
                                                    <center>W6 (LCD)</center>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <center><?php echo round($W1_norm, 4);?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo round($W2_norm, 4);?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo round($W3_norm, 4);?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo round($W4_norm, 4);?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo round($W5_norm, 4);?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo round($W6_norm, 4);?></center>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>


                <center>
                    <h4 class="header" style="margin-left: 24px; margin-bottom: 0px; margin-top: 24px; color: #635c73;">
                        Nilai Preferensi S:</h4>
                </center>
                <ul>
                    <li>
                        <div class="row">
                            <div class="card">
                                <div class="card-content">
                                    <h5 style="margin-bottom: 16px; margin-top: -6px;">Nilai Preferensi "S" (Weighted
                                        Product)</h5>
                                    <table class="responsive-table">

                                        <thead style="border-top: 1px solid #d0d0d0;">
                                            <tr>
                                                <th>
                                                    <center>Alternatif</center>
                                                </th>
                                                <th>
                                                    <center>Nilai S</center>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
												$query=mysqli_query($selectdb,"SELECT * FROM data_laptop");
												$no=1;
												$nilaiS = array();
												$total_S = 0; // Untuk normalisasi akhir V_i

												while ($data_laptop=mysqli_fetch_array($query)) {
													// Menentukan pangkat untuk kriteria (negatif untuk Cost, positif untuk Benefit)
													// Asumsi C1 (Harga) adalah Cost, C2-C6 adalah Benefit
													$pangkat_W1 = -$W1_norm; // Untuk Cost
													$pangkat_W2 = $W2_norm;   // Untuk Benefit (Processor)
													$pangkat_W3 = $W3_norm;   // Untuk Benefit (RAM)
													$pangkat_W4 = $W4_norm;   // Untuk Benefit (VGA)
													$pangkat_W5 = $W5_norm;   // Untuk Benefit (Memori)
													$pangkat_W6 = $W6_norm;   // Untuk Benefit (LCD)

													// Menghitung nilai S untuk setiap alternatif
													// Pastikan nilai kriteria tidak nol, karena pow(0, negatif) akan menghasilkan error
													$harga_val = ($data_laptop['harga_angka'] != 0) ? $data_laptop['harga_angka'] : 0.000001; // Hindari 0

													$S_alternatif = pow($harga_val, $pangkat_W1) *
																	pow($data_laptop['processor_angka'], $pangkat_W2) *
																	pow($data_laptop['ram_angka'], $pangkat_W3) *
																	pow($data_laptop['vga_angka'], $pangkat_W4) *
																	pow($data_laptop['memori_angka'], $pangkat_W5) *
																	pow($data_laptop['lcd_angka'], $pangkat_W6);

													$nilaiS[$no-1] = round($S_alternatif, 6);
													$total_S += $S_alternatif; // Akumulasi total S

													?>
                                            <tr>
                                                <td>
                                                    <center><?php echo "A",$no ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $nilaiS[$no-1] ?></center>
                                                </td>
                                            </tr>
                                            <?php
													$no++;
												}
												?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>


                <center>
                    <h4 class="header" style="margin-left: 24px; margin-bottom: 0px; margin-top: 24px; color: #635c73;">
                        Nilai Preferensi Akhir (V)
                    </h4>
                </center>
                <ul>
                    <li>
                        <div class="row">
                            <div class="card" style="margin-left: 320px;margin-right: 320px;">
                                <div class="card-content">
                                    <table class="responsive-table">

                                        <thead style="border-top: 1px solid #d0d0d0;">
                                            <tr>
                                                <th>
                                                    <center>Nilai Preferensi "V"</center>
                                                </th>
                                                <th>
                                                    <center>Nilai</center>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
													$query=mysqli_query($selectdb,"SELECT * FROM data_laptop"); // Query ulang untuk display
													$no=1;
													$nilaiV = array();
													foreach ($nilaiS as $key => $s_val) {
														// Handle division by zero for total_S if it happens
														$V_alternatif = ($total_S != 0) ? $s_val / $total_S : 0;
														array_push($nilaiV, $V_alternatif);
														?>
                                            <tr>
                                                <td>
                                                    <center><?php echo "V",($key+1) ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo round($V_alternatif, 6); ?></center>
                                                </td>
                                            </tr>
                                            <?php
														$no++;
													}
													?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>


                <center>
                    <h4 class="header" style="margin-left: 24px; margin-bottom: 0px; margin-top: 24px; color: #635c73;">
                        Nilai Preferensi tertinggi
                    </h4>
                </center>
                <ul>
                    <li>
                        <div class="row">
                            <div class="card" style="margin-left: 300px;margin-right: 300px;">
                                <div class="card-content">
                                    <table class="responsive-table">

                                        <thead style="border-top: 1px solid #d0d0d0;">
                                            <tr>
                                                <th>
                                                    <center>Nilai Preferensi tertinggi</center>
                                                </th>
                                                <th></th>
                                                <th>
                                                    <center>Alternatif HP terpilih</center>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <?php
														$testmax = -INF; // Inisialisasi dengan nilai sangat kecil
														if (!empty($nilaiV)) {
														    $testmax = max($nilaiV);
														}

														$index_terpilih = -1;
														for ($i=0; $i < count($nilaiV); $i++) {
															if ($nilaiV[$i] == $testmax) {
																$index_terpilih = $i;
																break; // Ambil yang pertama jika ada nilai max yang sama
															}
														}

														if ($index_terpilih != -1) {
															$query=mysqli_query($selectdb,"SELECT * FROM data_laptop where id_laptop = ".($index_terpilih+1));
															$data_laptop_terpilih = mysqli_fetch_array($query);
														?>
                                                <td>
                                                    <center><?php echo "V".($index_terpilih+1); ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo round($nilaiV[$index_terpilih], 6); ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data_laptop_terpilih['nama_laptop']; ?></center>
                                                </td>
                                                <?php
														} else {
															echo "<td colspan='3'><center>Tidak ada rekomendasi</center></td>";
														}
														?>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
                <div class="row center" \>
                    <a href="rekomendasi.php" id="download-button" class="waves-effect waves-light btn"
                        style="margin-top: 0px">Hitung Rekomendasi Ulang</a>
                </div>
            </div>
        </div>
    </div>
</body>

<?php include 'footer.php'; ?>