<?php
use PhpOffice\PhpSpreadsheet\IOFactory;

    session_start();
    include('koneksi.php');

    // Proteksi halaman admin
    if (!isset($_SESSION['loggedin']) || $_SESSION['role'] !== 'admin') {
        header('Location: login.php');
        exit;
    }
    if (isset($_POST['import_excel'])) {
        if (isset($_FILES['excel_file']) && $_FILES['excel_file']['error'] == 0) {
            require 'vendor/autoload.php'; // pastikan sudah install phpoffice/phpspreadsheet


            $fileTmpPath = $_FILES['excel_file']['tmp_name'];
            $spreadsheet = IOFactory::load($fileTmpPath);
            $sheet = $spreadsheet->getActiveSheet();
            $rows = $sheet->toArray();

            // Lewati baris header, mulai dari baris ke-2
            for ($i = 1; $i < count($rows); $i++) {
                $row = $rows[$i];
                // Pastikan urutan kolom sesuai: nama, harga, processor, ram, vga, memori, lcd
                $nama = $row[0];
                $harga = $row[1];
                $processor = $row[2];
                $ram = $row[3];
                $vga = $row[4];
                $memori = $row[5];
                $lcd = $row[6];

                $sql = "INSERT INTO `data_laptop` (`id_laptop`, `nama_laptop`, `harga_angka`, `processor_angka`, `ram_angka`, `vga_angka`, `memori_angka`, `lcd_angka`) 
                        VALUES (NULL, :nama_laptop, :harga_angka, :processor_angka, :ram_angka, :vga_angka, :memori_angka, :lcd_angka)";
                $stmt = $db->prepare($sql);
                $stmt->bindValue(':nama_laptop', $nama);
                $stmt->bindValue(':harga_angka', $harga);
                $stmt->bindValue(':processor_angka', $processor);
                $stmt->bindValue(':ram_angka', $ram);
                $stmt->bindValue(':vga_angka', $vga);
                $stmt->bindValue(':memori_angka', $memori);
                $stmt->bindValue(':lcd_angka', $lcd);
                $stmt->execute();
            }
        }
    }
    // Logika untuk logout
    if (isset($_GET['action']) && $_GET['action'] == 'logout') {
        session_unset();
        session_destroy();
        header('Location: login.php');
        exit;
    }
?>

<?php 
    if(isset($_POST["tambah_laptop"])){
        $nama      = $_POST["nama"];
        $harga     = $_POST["harga"];
        $processor = $_POST["processor"];
        $ram       = $_POST["ram"];
        $vga       = $_POST["vga"];
        $memori    = $_POST["memori"];
        $lcd       = $_POST["lcd"];
        
        $sql = "INSERT INTO `data_laptop` (`id_laptop`, `nama_laptop`, `harga_angka`, `processor_angka`, `ram_angka`, `vga_angka`, `memori_angka`, `lcd_angka`) 
                VALUES (NULL, :nama_laptop, :harga_angka, :processor_angka, :ram_angka, :vga_angka, :memori_angka, :lcd_angka)";
        $stmt = $db->prepare($sql);
        $stmt->bindValue(':nama_laptop', $nama);
        $stmt->bindValue(':harga_angka', $harga);
        $stmt->bindValue(':processor_angka', $processor);
        $stmt->bindValue(':ram_angka', $ram);
        $stmt->bindValue(':vga_angka', $vga);
        $stmt->bindValue(':memori_angka', $memori);
        $stmt->bindValue(':lcd_angka', $lcd);
        $stmt->execute();

        $sql_reorder = "SET @num := 0";
        $db->query($sql_reorder);
        $sql_update = "UPDATE data_laptop SET id_laptop = (@num := @num + 1) ORDER BY id_laptop";
        $db->query($sql_update);
        $sql_reset_ai = "ALTER TABLE data_laptop AUTO_INCREMENT = 1";
        $db->query($sql_reset_ai); 
    }

    if(isset($_POST["hapus_laptop"])){
        $id_hapus_laptop = $_POST['id_hapus_laptop'];
        $sql_delete = "DELETE FROM `data_laptop` WHERE `id_laptop` = :id_hapus_laptop";
        $stmt_delete = $db->prepare($sql_delete);
        $stmt_delete->bindValue(':id_hapus_laptop', $id_hapus_laptop);
        $stmt_delete->execute();
        // Reorder id_laptop agar urut kembali   
    }
    if(isset($_POST["tambah_user"])){
    $username = $_POST["username"];
    $password = password_hash($_POST["password"], PASSWORD_DEFAULT);
    $role     = $_POST["role"];
    $sql = "INSERT INTO user (username, password, role) VALUES (:username, :password, :role)";
    $stmt = $db->prepare($sql);
    $stmt->bindValue(':username', $username);
    $stmt->bindValue(':password', $password);
    $stmt->bindValue(':role', $role);
    $stmt->execute();
    }
    if(isset($_POST["hapus_user"])){
        $id_hapus_user = $_POST['id_hapus_user'];
        $sql_delete = "DELETE FROM `users` WHERE `id` = :id_hapus_user";
        $stmt_delete = $db->prepare($sql_delete);
        $stmt_delete->bindValue(':id_hapus_user', $id_hapus_user);
        $stmt_delete->execute();
        $query_reorder_id=mysqli_query($selectdb,"ALTER TABLE users AUTO_INCREMENT = 1");
    }
?>


<!DOCTYPE html>
<html>

<head>
    <title>Admin Dashboard</title>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link type="text/css" rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css"
        media="screen,projection" />
    <link rel="stylesheet" href="assets/css/table.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/js/materialize.min.js">
    </script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css">
</head>
<style>
body {
    display: flex;
    min-height: 100vh;
    flex-direction: column;
    /* background: linear-gradient(to right, #4CAF50, #8BC34A); */
    /* Gradient background */
    font-family: 'Roboto', sans-serif;
}

main {
    flex: 1 0 auto;
    display: flex;
    align-items: center;
    justify-content: center;
}

.login-card {
    background-color: #ffffff;
    padding: 40px;
    border-radius: 8px;
    /* box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15); */
    width: 90%;
    max-width: 400px;
    text-align: center;
}


.login-card h4 {
    color: #388e3c;
    /* Darker green for heading */
    margin-bottom: 30px;
    font-weight: 500;
}

nav {
    color: #000ff;
    background-color: #ffffff !important;
    /* box-shadow: 0 2px 10px rgba(0, 0, 20, 0.2); */
    width: 100%;
    height: 56px;
    line-height: 56px;
}

.container {
    max-width: 1280px !important;
    /* Atur sesuai kebutuhan */
    width: 80% !important;
    margin-left: auto;
    margin-right: auto;
}

.card {
    width: 100%;
    max-width: 1280px;
    /* Atur sesuai kebutuhan */
    margin: 0 auto 24px auto;
    /* Tengah dan beri jarak bawah */
    box-sizing: border-box;
}

.card-content {
    padding-left: 40px;
    padding-right: 40px;
}
</style>

<body>
    <div class="navbar-fixed">
        <nav>
            <div class="container">
                <div class="nav-wrapper">
                    <ul class="left" style="margin-left: -52px;">
                        <li><a href="index.php">HOME</a></li>
                        <li><a class="active" href="admin_dashboard.php">ADMIN</a></li>
                        <li><a href="?action=logout">LOGOUT</a></li>
                    </ul>
                </div>
            </div>
        </nav>
    </div>

    <div style="background-color: #efefef">
        <div class="container">
            <div class="section-card" style="padding: 20px 0px">
                <center>
                    <h4 class="header"
                        style="margin-left: 24px; margin-bottom: 35px; margin-top: 10px; color: #635c73;">
                        ADMIN DASHBOARD</h4>
                </center>

                <?php if (isset($_SESSION['pesan_sukses'])): ?>
                <div class="card-panel green lighten-4 green-text text-darken-4">
                    <?php echo $_SESSION['pesan_sukses']; unset($_SESSION['pesan_sukses']); ?>
                </div>
                <?php endif; ?>
                <?php if (isset($_SESSION['pesan_error'])): ?>
                <div class="card-panel red lighten-4 red-text text-darken-4">
                    <?php echo $_SESSION['pesan_error']; unset($_SESSION['pesan_error']); ?>
                </div>
                <?php endif; ?>

                <ul>
                    <li>
                        <div class="row">
                            <div class="card">
                                <div class="card-content">
                                    <h5 style=" TEXT-ALIGN: CENTER; margin-bottom: 16px; margin-top: -2px;">KELOLA
                                        DAFTAR LAPTOP</h5>
                                    <a href="#tambah" class="waves-effect waves-light btn green modal-trigger"
                                        style="margin-bottom: 10px; border-radius: 8px;">
                                        <i class="material-icons left">add</i>Tambah Data
                                    </a>
                                    <!-- <a href="export_excel.php" class="waves-effect waves-light btn blue"
                                        style="margin-bottom: 10px;">
                                        <i class="material-icons left">file_download</i>Export Data
                                    </a>
                                    <a href="import_excel.php" class="waves-effect waves-light btn orange"
                                        style="margin-bottom: 10px;">
                                        <i class="material-icons left">file_upload</i>Import Excel
                                    </a> -->

                                    <table id="table_laptop" class="responsive-table striped">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <center>No </center>
                                                </th>
                                                <th>
                                                    <center>Nama Laptop</center>
                                                </th>
                                                <th>
                                                    <center>Harga</center>
                                                </th>
                                                <th>
                                                    <center>Processor</center>
                                                </th>
                                                <th>
                                                    <center>RAM</center>
                                                </th>
                                                <th>
                                                    <center>Kartu Grafis</center>
                                                </th>
                                                <th>
                                                    <center>Memori</center>
                                                </th>
                                                <th>
                                                    <center>LCD</center>
                                                </th>
                                                <th>
                                                    <center>Hapus</center>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $query = mysqli_query($selectdb, "SELECT * FROM data_laptop ORDER BY id_laptop ASC");
                                            $no = 1;
												while ($data=mysqli_fetch_array($query)) {
                                            ?>
                                            <tr>
                                                <td>
                                                    <center><?php echo $no++; ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data['nama_laptop'] ?></center>
                                                </td>
                                                <td>
                                                    <center>
                                                        <?php echo 'Rp. ', number_format($data['harga_angka'], 0, ',', '.'); ?>
                                                    </center>
                                                </td>

                                                <td>
                                                    <center><?php echo $data['processor_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data['ram_angka'],' GB'?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data['vga_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data['memori_angka'], ' GB' ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data['lcd_angka'], ' Inch' ?></center>
                                                </td>
                                                <td>
                                                    <center>
                                                        <!-- <a href="edit_laptop.php?id=<?php echo $data['id_laptop'] ?>"
                                                            class="btn-floating btn-small waves-effect waves-light blue"
                                                            style="height: 32px; width: 32px;"><i
                                                                style="line-height: 32px;"
                                                                class="material-icons">edit</i></a> -->
                                                        <form method="POST" style="display:inline-block;">
                                                            <input type="hidden" name="id_hapus_laptop"
                                                                value="<?php echo $data['id_laptop'] ?>">
                                                            <button type="submit" name="hapus_laptop"
                                                                style="height: 32px; width: 32px;"
                                                                class="btn-floating btn-small waves-effect waves-light red"
                                                                onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?');"><i
                                                                    style="line-height: 32px;"
                                                                    class="material-icons">delete</i></button>
                                                        </form>
                                                    </center>
                                                </td>
                                            </tr>
                                            <?php
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="row">
                            <div class="card">
                                <div class="card-content">
                                    <h5 style=" text-align: center; margin-bottom: 16px; margin-top: -6px;">KELOLA USER
                                    </h5>
                                    <a href="#tambah_user" class="waves-effect waves-light btn blue modal-trigger"
                                        style="margin-bottom: 10px; border-radius: 8px;">
                                        <i class="material-icons left">person_add</i>Tambah User
                                    </a>
                                    <table id="table_user" class="responsive-table striped">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <center>No</center>
                                                </th>
                                                <th>
                                                    <center>Username</center>
                                                </th>
                                                <th>
                                                    <center>Role</center>
                                                </th>
                                                <th>
                                                    <center>Hapus</center>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                            $query_user = mysqli_query($selectdb, "SELECT * FROM users ORDER BY id ASC"); // Menggunakan tabel `users`
                            $no_user = 1;
                            while ($user = mysqli_fetch_array($query_user)) {
                            ?>
                                            <tr>
                                                <td>
                                                    <center><?= $no_user++; ?></center>
                                                </td>
                                                <td>
                                                    <center><?= htmlspecialchars($user['username']); ?></center>
                                                </td>
                                                <td>
                                                    <center><?= htmlspecialchars($user['role']); ?></center>
                                                </td>
                                                <td>
                                                    <center>
                                                        <!-- <a href="edit_user.php?id=<?= $user['id'] ?>"
                                                            class="btn-floating btn-small waves-effect waves-light blue"
                                                            style="height: 32px; width: 32px;"><i
                                                                style="line-height: 32px;"
                                                                class="material-icons">edit</i></a> -->
                                                        <form method="POST" style="display:inline-block;">
                                                            <input type="hidden" name="id_hapus_user"
                                                                value="<?= $user['id'] ?>">
                                                            <button type="submit" name="hapus_user"
                                                                style="height: 32px; width: 32px;"
                                                                class="btn-floating btn-small waves-effect waves-light red"
                                                                onclick="return confirm('Apakah Anda yakin ingin menghapus user ini?');"><i
                                                                    style="line-height: 32px;"
                                                                    class="material-icons">delete</i></button>
                                                        </form>
                                                    </center>
                                                </td>
                                            </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div id="tambah" class="modal" style="width: 40%; height: auto;">
        <div class="modal-content ">
            <div class="col s12">
                <div class="card-content">
                    <div class="row">
                        <center>
                            <h5 style="margin-top:-8px;">Masukan Laptop</h5>
                        </center>
                        <form method="POST" action="">
                            <div class="row">
                                <div class="col s12">
                                    <div class="input-field col s12">
                                        <input id="nama" name="nama" type="text" required>
                                        <label for="nama">Nama Laptop</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <input id="harga" name="harga" type="number" required>
                                        <label for="harga">Harga</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <input id="processor" name="processor" type="number" required>
                                        <label for="processor">Seri Processor</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <input id="vga" name="vga" type="number" required>
                                        <label for="vga">Seri VGA</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <select name="ram" required>
                                            <option value="" disabled selected>Pilih RAM</option>
                                            <option value="2">2 Gb</option>
                                            <option value="3">4 Gb</option>
                                            <option value="9">8 Gb</option>
                                            <option value="16">16 Gb</option>
                                            <option value="32">32 Gb</option>
                                        </select>
                                        <label>RAM</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <select name="memori" required>
                                            <option value="" disabled selected>Pilih Penyimpanan</option>
                                            <option value="128">128 GB</option>
                                            <option value="256">256 GB</option>
                                            <option value="512">512 GB</option>
                                            <option value="1024">1 Tera</option>
                                        </select>
                                        <label>Memory Penyimpanan</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <select name="lcd" required>
                                            <option value="" disabled selected>Pilih Ukuran LCD</option>
                                            <option value="11">11 Inch</option>
                                            <option value="13">13 Inch</option>
                                            <option value="14">14 Inch</option>
                                            <option value="15">15 Inch</option>
                                            <option value="16">16 Inch</option>
                                        </select>
                                        <label>Ukuran LCD</label>
                                    </div>

                                </div>
                            </div>
                            <center><button name="tambah_laptop" type="submit" class="waves-effect waves-light btn teal"
                                    style="margin-top: 0px;">Tambah</button></center>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer" style="height: auto;">
            <a href="#!" class="modal-action modal-close waves-effect waves-green btn-flat">Tutup</a>
        </div>
    </div>
    <div id="tambah_user" class="modal" style="width: 30%; height: auto;">
        <div class="modal-content">
            <h5>Tambah User</h5>
            <form method="POST" action="">
                <div class="input-field">
                    <input id="username_user" name="username" type="text" required>
                    <label for="username_user">Username</label>
                </div>
                <div class="input-field">
                    <input id="password_user" name="password" type="password" required>
                    <label for="password_user">Password</label>
                </div>
                <div class="input-field">
                    <select name="role" required>
                        <option value="" disabled selected>Pilih Role</option>
                        <option value="admin">Admin</option>
                        <option value="user">User</option>
                    </select>
                    <label>Role</label>
                </div>
                <center>
                    <button name="tambah_user" type="submit" class="waves-effect waves-light btn blue"
                        style="margin-top: 10px;">Tambah</button>
                </center>
            </form>
        </div>
        <div class="modal-footer" style="height: auto;">
            <a href="#!" class="modal-action modal-close waves-effect waves-green btn-flat">Tutup</a>
        </div>
    </div>
    <div class="footer-copyright" style="padding: 0px 0px; background-color: white">
        <div class="container">
            <p align="center" style="color: #999">&copy; Sistem Pendukung Keputusan Pemilihan Smartphone 2018.</p>
        </div>
    </div>

    <script type="text/javascript">
    $(document).ready(function() {
        // Inisialisasi semua modal
        $('.modal').modal();
        // Inisialisasi semua select Materialize
        $('select').formSelect();

        // Inisialisasi DataTables untuk masing-masing tabel
        $('#table_laptop').DataTable({
            "paging": true, // Aktifkan pagination
            "ordering": true, // Aktifkan sorting
            "info": true // Tampilkan info entri
        });
        $('#table_user').DataTable({
            "paging": true, // Aktifkan pagination
            "ordering": true, // Aktifkan sorting
            "info": true // Tampilkan info entri
        });
    });
    </script>
</body>

</html>