<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

    <title>Monitoring Trainer IoT</title>

    <style>
        body {
            background-color: #f4f6f9;
        }
        .sensor-card {
            border-radius: 15px;
            transition: transform 0.2s ease-in-out;
            min-height: 200px; /* Tambahkan tinggi minimum */
        }
        .sensor-card:hover {
            transform: scale(1.02);
        }
        .sensor-icon {
            font-size: 3rem;
        }
        .status-badge {
            font-size: 0.9rem;
            padding: 5px 10px;
            border-radius: 8px;
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function(){
            setInterval(function() {
                $("#ceksuhu").load("ceksuhu_new.php");
                $("#cekvibrasi").load("cekvibrasi.php");
                $("#cektegangan").load("cektegangan.php");
                $("#cekarus").load("cekarus.php");
                $("#cekfault").load("cekfault.php");
            }, 1000);
        });
    </script>
</head>
<body>

<div class="container py-5">
    <h1 class="mb-4 text-center fw-bold">📊 MONITORING SUCTION BLOWER MOTOR</h1>
    <div class="row g-4">
        <div class="col-md-4">
            <div class="card sensor-card shadow-sm">
                <div class="card-body text-center">
                    <i class="bi bi-thermometer-half text-danger sensor-icon"></i>
                    <h5 class="mt-3">Suhu</h5>
                    <div id="ceksuhu" class="fs-4 fw-bold text-danger">-- &#8451;</div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card sensor-card shadow-sm">
                <div class="card-body text-center">
                    <i class="bi bi-broadcast text-warning sensor-icon"></i>
                    <h5 class="mt-3">Getaran</h5>
                    <div id="cekvibrasi" class="fs-4 fw-bold text-warning">-- g</div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card sensor-card shadow-sm">
                <div class="card-body text-center">
                    <i class="bi bi-lightning-charge text-primary sensor-icon"></i>
                    <h5 class="mt-3">Tegangan</h5>
                    <div id="cektegangan" class="fs-4 fw-bold text-primary">-- V</div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card sensor-card shadow-sm">
                <div class="card-body text-center">
                    <i class="bi bi-battery-charging text-info sensor-icon"></i>
                    <h5 class="mt-3">Arus</h5>
                    <div id="cekarus" class="fs-4 fw-bold text-info">-- A</div>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card sensor-card shadow-sm">
                <div class="card-body text-center">
                    <i class="bi bi-exclamation-triangle-fill text-danger sensor-icon"></i>
                    <h5 class="mt-3">Status Fault</h5>
                    <div id="cekfault" class="fs-4 fw-bold text-danger">--</div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>